unit ACMEnum;

interface

uses
  MMSystem, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMACMDlg, MMRegs, MMWaveIO;

type
  TForm1 = class(TForm)
    ACM: TMMACM;
    Combo1: TComboBox;
    Label1: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure ACMFormatEnum(Sender: TObject; pwfx: PWaveFormatEx; Description: String; var Continue: Boolean);
  private
  public
    procedure FreeFormats;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.FreeFormats;
var
   i: integer;
begin
   for i := 0 to Combo1.Items.Count-1 do
   begin
      if (Combo1.Items.Objects[i] <> nil) then
          GlobalFreePtr(Combo1.Items.Objects[i]);
   end;
   Combo1.Clear;
end;

{------------------------------------------------------------------------------}
procedure TForm1.ACMFormatEnum(Sender: TObject; pwfx: PWaveFormatEx; Description: String; var Continue: Boolean);
begin
   Combo1.Items.AddObject(Description,Pointer(wioCopyWaveFormat(pwfx)));
   Continue := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
var
   i,idx: integer;
   pwfx,pwfxList: PWaveFormatEx;
begin
   if ACM.EnumerateFormats(WAVE_FORMAT_PCM) then
   begin
      pwfx := acmGetFormatFromRegistry(HKEY_CURRENT_USER,
                                       'Software\SwiftSoft\APP',
                                       'WaveFormat');
      idx := 0;
      if (pwfx <> nil) then
      begin
         for i := 0 to Combo1.Items.Count-1 do
         begin
            pwfxList := Pointer(Combo1.Items.Objects[i]);
            if (pwfxList.cbSize = pwfx.cbSize) then
            begin
               if CompareMem(pwfx,pwfxList,wioSizeOfWaveFormat(pwfx)) then
               begin
                  idx := i;
                  break;
               end;
            end;
         end;
         GlobalFreePtr(pwfx);
      end;
      Combo1.ItemIndex := idx;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if (Combo1.Items.Count > 0) and (Combo1.ItemIndex >= 0) then
   begin
      acmSaveFormatToRegistry(Pointer(Combo1.Items.Objects[Combo1.ItemIndex]),
                                      HKEY_CURRENT_USER,
                                     'Software\SwiftSoft\APP',
                                      'WaveFormat');
   end;
   FreeFormats;
end;

end.
